@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:      create_usb_file.bat
REM
REM  Usage:	Run without parameters to see script usage
REM	
REM ----------------------------------------------------------------------------

REM ### system variables - do not change ###
set REPOSITORY=psk.repository.xml
set USB_FILE=setup.bin

REM ### user variables ###
set XML_FILE=setup.xml
set CURRENT_MEBx_PASSWORD=admin
set NEW_MEBx_PASSWORD=Admin44$
set NUM_RECORDS=10


REM ### logic begins here ###

if "%1"=="" goto usage

@echo.
@echo Volume %1 is about to be formatted. Press Ctrl-C to abort.
@echo.
format %1 /FS:FAT /V:AMT_USB
if errorlevel 1 goto end

USBfile -create %USB_FILE% %XML_FILE% %CURRENT_MEBx_PASSWORD% %NEW_MEBx_PASSWORD% %NUM_RECORDS%

@echo.
@echo copying %USB_FILE% to %1

copy %USB_FILE% %1

@echo.
@echo In order for the Configuration Server to use the 
@echo newly created PID/PPS pairs, the contents of %XML_FILE% 
@echo must either replace %REPOSITORY%, thus overwriting any 
@echo existing information in %REPOSITORY%, or be manually edited
@echo into %REPOSITORY%
yesno "Copy %XML_FILE% to %REPOSITORY% [y/N] ?" N
IF NOT errorlevel 1 goto end
copy/y %XML_FILE% %REPOSITORY%

goto end


:usage
@echo.
@echo %0 usage:
@echo.
@echo 	create_usb_file x:
@echo where x: is a USB volume.
@echo.
@echo %0 formats the USB volume with a FAT16 filesystem, 
@echo creates the usb file %USB_FILE%, and a corresponding 
@echo xml file %XML_FILE% with just the pid/psk values
@echo (overwriting any existing files).
@echo.

:end